/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.network;

import com.technicalitiesmc.lib.network.Packet;
import com.technicalitiesmc.scm.network.ComponentBreakPacket;
import com.technicalitiesmc.scm.network.ComponentPlacePacket;
import com.technicalitiesmc.scm.network.ComponentSyncPacket;
import com.technicalitiesmc.scm.network.ComponentUsePacket;
import com.technicalitiesmc.scm.network.PickPaletteColorPacket;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class SCMNetworkHandler {
    private static SimpleChannel INSTANCE;
    private static int ID;

    public static void registerPackets() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("supercircuitmaker", "main"), () -> "1.0", s -> true, s -> true);
        SCMNetworkHandler.register(ComponentSyncPacket.class, ComponentSyncPacket::new);
        SCMNetworkHandler.register(ComponentPlacePacket.class, ComponentPlacePacket::new);
        SCMNetworkHandler.register(ComponentBreakPacket.class, ComponentBreakPacket::new);
        SCMNetworkHandler.register(ComponentUsePacket.class, ComponentUsePacket::new);
        SCMNetworkHandler.register(PickPaletteColorPacket.class, PickPaletteColorPacket::new);
    }

    private static <T extends Packet> void register(Class<T> type, Function<FriendlyByteBuf, T> decoder) {
        INSTANCE.messageBuilder(type, ID++).encoder(Packet::encode).decoder(decoder).consumer((first, second) -> first.handle((NetworkEvent.Context)second.get())).add();
    }

    public static void sendToClient(Packet packet, ServerPlayer player) {
        INSTANCE.sendTo((Object)packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void broadcastToClientsWatching(Packet packet, ServerLevel level, ChunkPos pos) {
        level.m_7726_().f_8325_.m_183262_(pos, false).forEach(player -> SCMNetworkHandler.sendToClient(packet, player));
    }

    public static void sendToServer(Packet packet) {
        INSTANCE.sendToServer((Object)packet);
    }

    static {
        ID = 0;
    }
}

